const Partner = require("../models/partnerModel");
const {
  deleteOldPartnerImage,
} = require("../storage/middlewareStorage/uploadPartnerMedia");

exports.getAllPartners = async (req, res) => {
  try {
    const partners = await Partner.find();
    res.status(200).json({
      status: "success",
      results: partners.length,
      data: { partners },
    });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};

exports.getPartner = async (req, res) => {
  try {
    const partner = await Partner.findById(req.params.id);
    if (!partner) {
      return res.status(404).json({ message: "Partner not found" });
    }
    res.status(200).json({ status: "success", data: { partner } });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};

exports.createPartner = async (req, res) => {
  try {
    if (req.file) req.body.image = req.file.filename;

    const newPartner = await Partner.create(req.body);
    res.status(201).json({ status: "success", data: { partner: newPartner } });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};

exports.updatePartner = async (req, res) => {
  try {
    const partner = await Partner.findById(req.params.id);
    if (!partner) return res.status(404).json({ message: "Partner not found" });

    // Handle Image Update
    if (req.file) {
      await deleteOldPartnerImage(partner.image); // Delete old
      req.body.image = req.file.filename; // Set new
    }

    const updatedPartner = await Partner.findByIdAndUpdate(
      req.params.id,
      req.body,
      {
        new: true,
        runValidators: true,
      }
    );

    res
      .status(200)
      .json({ status: "success", data: { partner: updatedPartner } });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};

exports.deletePartner = async (req, res) => {
  try {
    const partner = await Partner.findById(req.params.id);
    if (!partner) return res.status(404).json({ message: "Partner not found" });

    // Delete image from server
    await deleteOldPartnerImage(partner.image);

    // Delete from DB
    await Partner.findByIdAndDelete(req.params.id);

    res.status(204).json({ status: "success", data: null });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};
